#
# Copyright 2005 IBM Corporation
#
# Author: Michael Strosaker <strosake@us.ibm.com>
#

# parse_se
# Parses serviceable event data that is output by rpa_ela.  The data should
# be made available on stdin.
#
# First return value:   a hash containing all the variables in the serviceable
#                       event except for menugoal text and FRU callouts
# Second return value:  an array containing all the FRU callouts; each
#                       element contains a space-separated callout description
# Third return value:	an array containing any menugoal text
sub parse_se
{
	my %se_vars = ();
	my @frus = ();
	my @menutext = ();

	while (<STDIN>) {
		chomp;

		$pos = index($_, ":");
		if ($pos > 0) {
			$tag = substr($_, 0, $pos);
			$value = substr($_, $pos+2);
		}
		else {
			$tag = $_;
			$value = "";
		}
		if ($tag eq "Menu Text") {
			push(@menutext, $value);
			while (($next = <STDIN>) ne "End Menu Text\n") {
				chomp $next;
				push(@menutext, $next);
			}
		}
		elsif ($tag eq "FRU(Location,FRU p/n,Ref-code)") {
			($p1, $p2, $p3) = split /\s+/, $value;
			push(@frus, "$p1 $p2 $p3");
		}
		elsif ($tag eq "FRU_SRC(priority,type,procedure,location,".
				"p/n,s/n,ccin)") {
			($p1, $p2, $p3, $p4, $p5, $p6, $p7) = split /\s+/, $value;
			push(@frus, "$p1 $p2 $p3 $p4 $p5 $p6 $p7");
		}
		elsif (substr($tag, 0, 4) eq "Refc") {
			$se_vars{$tag} = sprintf("%08X", hex(lc($value)));
		}
		else {
			$se_vars{$tag} = $value;
		}
	}
	return (\%se_vars, \@frus, \@menutext);
}

1;
